/*
 * Decompiled with CFR 0.152.
 */
package com.flemmli97.tenshilib.common.entity;

import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityUtil {
    @Nullable
    public static <T extends Entity> T findFromUUID(Class<T> clss, World world, UUID uuid) {
        return (T)EntityUtil.findFromUUID(clss, world, uuid, t -> true);
    }

    @Nullable
    public static <T extends Entity> T findFromUUID(Class<T> clss, World world, UUID uuid, Predicate<T> pred) {
        if (world instanceof ServerWorld) {
            Entity e = ((ServerWorld)world).func_217461_a(uuid);
            if (e != null && clss.isAssignableFrom(e.getClass()) && pred.test(e)) {
                return (T)e;
            }
        } else {
            for (Entity e : ((ClientWorld)world).func_217416_b()) {
                if (!e.func_110124_au().equals(uuid) || !clss.isAssignableFrom(e.getClass()) || !pred.test(e)) continue;
                return (T)e;
            }
        }
        return null;
    }

    public static ItemStack findItem(PlayerEntity player, Predicate<ItemStack> pred, boolean searchArmor, boolean offHand) {
        for (ItemStack stack : player.field_71071_by.field_70462_a) {
            if (!pred.test(stack)) continue;
            return stack;
        }
        if (searchArmor) {
            for (ItemStack stack : player.field_71071_by.field_70460_b) {
                if (!pred.test(stack)) continue;
                return stack;
            }
        }
        if (offHand) {
            for (ItemStack stack : player.field_71071_by.field_184439_c) {
                if (!pred.test(stack)) continue;
                return stack;
            }
        }
        return ItemStack.field_190927_a;
    }
}

